unit Ani1;

interface

uses
  {$IFDEF WINDOWS}
  Winprocs, WinTypes,
  {$ENDIF}
  {$IFDEF WIN32}
  Windows,
  {$ENDIF} Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Mathimge, mmsystem;

type
  TAniForm = class(TForm)
    ColorDialog1: TColorDialog;
    Panel1: TPanel;
    Button2: TButton;
    Button1: TButton;
    Button3: TButton;
    Button7: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Label1: TLabel;
    Panel2: TPanel;
    MathImage1: TMathImage;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    procedure CreateParams(var Params: TCreateParams); override;
    { Private declarations }
  public
    points:TFloatPointList;
    pointslist:TFloatPointListList;
    wait:boolean;
    drawcolor,backcolor,axiscolor:TColor;
    procedure makespiral(a:extended;var p:TFloatPointList);
    procedure makespirals;
    { Public declarations }
  end;

implementation

uses MDemo1;

{$R *.DFM}

procedure TAniForm.CreateParams(var Params: TCreateParams);
begin
  inherited  CreateParams(Params);
  with Params do
  begin
    WndParent := Demoform.Handle;
    Parent := Demoform;
    Style := WS_CHILD OR WS_CLIPSIBLINGS OR WS_CLIPCHILDREN;
    Align := alClient;
  end;
end;

function dist(x:extended):extended;
begin
  result:=2-0.1*x;
end;


procedure TAniForm.makespiral(a:extended;var p:TFloatpointlist);
var theta,dtheta,r:extended;
begin
  p:=TFloatpointlist.create;
  dtheta:=2*pi/150;
  theta:=0;
  repeat
    r:=dist(a*theta);
    p.add(r*cos(theta),r*sin(theta));
    theta:=theta+dtheta;
  until r<0.02;
end;

procedure TAniForm.makespirals;
var theta,dtheta,a,r:extended; i:integer;
begin
  if pointslist<>nil then pointslist.free;
  pointslist:=TFloatpointlistlist.create;
  dtheta:=2*pi/150;
  for i:=0 to 178 do
  begin
    pointslist.add;
    a:=1-i/200;
    theta:=0;
    repeat
      r:=dist(a*theta);
      pointslist.addToCurrent(r*cos(theta),r*sin(theta));
      theta:=theta+dtheta;
    until r<0.02;
  end;
end;


procedure TAniForm.FormCreate(Sender: TObject);
begin
  Points:=nil;
  Pointslist:=nil;
  with mathimage1 do
  begin
    controlstyle:=controlstyle+[csOpaque];
    setworld(-2,-2,2,2);
  end;
  drawcolor:=clred; backcolor:=clnavy;
  axiscolor:=clsilver;
end;

procedure TAniForm.Button1Click(Sender: TObject);
var i:integer; time:longint; pointsloc:TFloatPointList;
begin
  Screen.cursor:=crhourglass;
  with mathimage1 do
  begin
    with canvas.pen do
    begin
      mode:=pmXOR;
    end;
    makespiral(1,pointsloc);
    drawpolyline(pointsloc);
    repaint;
    for i:=1 to 178 do
    begin
      points:=pointsloc;
      makespiral(1-i/200,pointsloc);
      drawpolyline(points);
      drawpolyline(pointsloc);
      repaint;
      points.free;
    end;
    pointsloc.free;
  end;
  screen.cursor:=crDefault;
end;

procedure TAniForm.FormResize(Sender: TObject);
begin
  mathimage1.reset;
  button2click(self);
end;

procedure TAniForm.Button2Click(Sender: TObject);
begin
  with mathimage1 do
  begin
    with canvas do
    begin
      pen.mode:=pmcopy;
      brush.color:=backcolor;
      pen.color:=backcolor;
      font.color:=axiscolor;
      rectangle(0,0,width,height);
      pen.color:=drawcolor;
    end;
    drawaxes('','',true,axiscolor,axiscolor);
  end;
end;

procedure TAniForm.Button3Click(Sender: TObject);
var i,x,y,w,h:integer;  time:longint;
begin
  Screen.Cursor:=crHourGlass;
  with mathimage1 do
  begin
    canvas.pen.mode:=pmcopy;
    x:=windowx(-2)+1; y:=windowy(2);
      w:=windowx(2); h:=windowy(-2)-1;
    makespiral(1,points);
    drawpolyline(points);
    repaint;
    points.free;
    for i:=1 to 178 do
    begin
      makespiral(1-i/200,points);
      canvas.brush.color:=backcolor;
      canvas.pen.color:=backcolor;
      canvas.rectangle(x,y,w,h);
      canvas.pen.color:=axiscolor;
      movetopoint(-2,0);
      drawlineto(2,0);
      movetopoint(0,2);
      drawlineto(0,-2);
      canvas.pen.color:=drawcolor;
      drawpolyline(points);
      repaint;
      points.free;
    end;
  end;
  Screen.Cursor:=crDefault;
end;
procedure TAniForm.Button4Click(Sender: TObject);
begin
  with colordialog1 do
  if execute then
  begin
    backcolor:=color;
    button2click(self);
  end;
end;



procedure TAniForm.Button5Click(Sender: TObject);
begin
  with colordialog1 do
  if execute then
  begin
    drawcolor:=color;
    button2click(self);
  end;
end;

procedure TAniForm.Button6Click(Sender: TObject);
begin
  with colordialog1 do
  if execute then
  begin
    axiscolor:=color;
    button2click(self);
  end;
end;

procedure TAniForm.Button7Click(Sender: TObject);
var p:TFloatPointlist; i:longint; x,y,w,h:integer;
begin
  Screen.cursor:=crHourGlass;
  with mathimage1 do
  begin
    canvas.pen.mode:=pmcopy;
    x:=windowx(-2)+1; y:=windowy(2);
    w:=windowx(2); h:=windowy(-2)-1;
    makespirals;
    p:=PointsList.firstlist;
    for i:=1 to PointsList.count do
    begin
      canvas.pen.color:=backcolor;
      canvas.rectangle(x,y,w,h);
      canvas.pen.color:=axiscolor;
      movetopoint(-2,0);
      drawlineto(2,0);
      movetopoint(0,2);
      drawlineto(0,-2);
      canvas.pen.color:=drawcolor;
      DrawPolyline(p);
      repaint;
      p:=p.next;
    end;
  end;
  application.processmessages;
  label1.caption:=IntToStr(pointslist.currentlist.count);
  Screen.cursor:=crDefault;
end;

procedure TAniForm.FormDestroy(Sender: TObject);
begin
  if pointslist<>nil then pointslist.free;
end;

end.


